CREATE OR REPLACE VIEW `student_course_enrollment_search` AS
    select 
        round((rand() * 10000), 0) AS `id`,
        `g`.`id` AS `programId`,
        `g`.`programName` AS `programName`,
        `f`.`id` AS `batchId`,
        `f`.`batchName` AS `batchName`,
        if(isnull(`b`.`id`), -(1), `b`.`id`) AS `periodId`,
        if(isnull(`b`.`id`),
            '-',
            `b`.`programPeriodName`) AS `periodName`,
        if(isnull(`e`.`id`), -(1), `e`.`id`) AS `courseVariantId`,
        if(isnull(`e`.`id`),
            '-',
            `e`.`courseVariantCode`) AS `courseVariantCode`,
        `h`.`id` AS `courseId`,
        CONCAT(`h`.`courseCode`,' / ',`h`.`courseName`) AS `courseName`,
        `a`.`id` AS `sectionId`,
        `a`.`sectionCode` AS `sectionCode`,
        `d`.`whetherOptional` AS `courseType`,
        `h`.`assignSectionType` AS `sectionType`
    from
        ((((((`batch_courses` `c`
        left join (`sections` `a`
        left join `prog_batch_period_config` `b` ON ((`b`.`id` = `a`.`periodId`))) ON ((`c`.`batchId` = `b`.`programBatchId`)))
        left join `program_batch_course_param` `d` ON (((`d`.`sectionId` = `a`.`id`)
            and (`d`.`courseId` = `c`.`courseId`))))
        left join `course_variants` `e` ON ((`e`.`id` = `d`.`courseVarientId`)))
        left join `batches` `f` ON ((`f`.`id` = `b`.`programBatchId`)))
        left join `programs` `g` ON ((`g`.`id` = `f`.`programId`)))
        left join `courses` `h` ON ((`h`.`id` = `c`.`courseId`))) 
    union all select 
        round((rand() * 10000), 0) AS `id`,
        `f`.`id` AS `programId`,
        `f`.`programName` AS `programName`,
        `e`.`id` AS `batchId`,
        `e`.`batchName` AS `batchName`,
        if(isnull(`d`.`id`), -(1), `d`.`id`) AS `periodId`,
        if(isnull(`d`.`id`),
            '-',
            `d`.`programPeriodName`) AS `periodName`,
        if(isnull(`b`.`id`), -(1), `b`.`id`) AS `courseVariantId`,
        if(isnull(`b`.`id`),
            '-',
            `b`.`courseVariantCode`) AS `courseVariantCode`,
        `g`.`id` AS `courseId`,
        CONCAT(`g`.`courseCode`,' / ',`g`.`courseName`) AS `courseName`,
        `a`.`id` AS `sectionId`,
        `a`.`sectionCode` AS `sectionCode`,
        `c`.`whetherOptional` AS `courseType`,
        `g`.`assignSectionType` AS `sectionType`
    from
        ((((((`sections` `a`
        left join `course_variants` `b` ON ((`b`.`id` = `a`.`courseVariantId`)))
        left join `program_batch_course_param` `c` ON ((`c`.`courseVarientId` = `b`.`id`)))
        left join `prog_batch_period_config` `d` ON ((`c`.`progBatchPeriodConfigId` = `d`.`id`)))
        left join `batches` `e` ON ((`e`.`id` = `d`.`programBatchId`)))
        left join `programs` `f` ON ((`f`.`id` = `e`.`programId`)))
        left join `courses` `g` ON ((`g`.`id` = `b`.`courseId`)))